/****** Object:  StoredProcedure [dbo].[usp_Save_Level_Of_Care]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Save_Level_Of_Care]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Save_Level_Of_Care]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- 
-- =============================================
-- Author:		Valentinm
-- Create date: 05/18/2012
-- Description: Save level of care.
-- =============================================
-- =============================================
-- Update by:	silvicap
-- Update date: 26.10.2012
-- Description:	Separated events from acts. 
-- =============================================

CREATE PROCEDURE [dbo].[usp_Save_Level_Of_Care]
	@PATIENT_UID UNIQUEIDENTIFIER,
	@ASSIGNMENT_DATE DATETIME,
	@LEVEL_OF_CARE NVARCHAR(50),	
	@WARD_LIST NVARCHAR(MAX)
AS
SET NOCOUNT ON
BEGIN
	DECLARE @ADMISSION_ID INT, @CREATION_UTC_DATE DATETIME, @HAS_DISCHARGE BIT
	
	IF (@PATIENT_UID IS NULL)
		RETURN
			
	CREATE TABLE #WARDS (WARD_UID UNIQUEIDENTIFIER)
    INSERT INTO #WARDS (WARD_UID)
    SELECT CAST(VALUE AS UNIQUEIDENTIFIER)
     FROM dbo.fn_Split(@WARD_LIST, ',') 					
	
    SELECT TOP 1 @ADMISSION_ID = AE.ID, @CREATION_UTC_DATE = AE.CREATION_UTC_DATE, @HAS_DISCHARGE = AE.HAS_DISCHARGE
    FROM ADMISSION_EVN AS AE
    INNER JOIN #WARDS AS WARD ON AE.WARD_UID = WARD.WARD_UID
    WHERE PATIENT_UID = @PATIENT_UID 
    ORDER BY AE.ADMISSION_DATE DESC

	IF (@ADMISSION_ID IS NULL)
		RETURN
	
	IF(@HAS_DISCHARGE = 1)
		RETURN;
	
	DECLARE @LEVEL_OF_CARE_ID INT;
	SELECT @LEVEL_OF_CARE_ID = ID
	FROM ADMISSION_LEVEL_OF_CARE
	WHERE ADMISSION_ID = @ADMISSION_ID;
	
	IF @LEVEL_OF_CARE_ID IS NULL
		BEGIN
			INSERT INTO ADMISSION_LEVEL_OF_CARE(ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE)
			VALUES(@ADMISSION_ID, @LEVEL_OF_CARE, @ASSIGNMENT_DATE)
			SET @LEVEL_OF_CARE_ID  = scope_identity()
		END
	ELSE
		BEGIN
			UPDATE ADMISSION_LEVEL_OF_CARE
			SET 
				LEVEL_OF_CARE = @LEVEL_OF_CARE,
				CREATION_DATE = @ASSIGNMENT_DATE
			WHERE ID = @LEVEL_OF_CARE_ID;
		END
	DROP TABLE #WARDS
	
	SELECT ID, ADMISSION_ID, LEVEL_OF_CARE,CREATION_DATE
	FROM ADMISSION_LEVEL_OF_CARE
	WHERE ID = @LEVEL_OF_CARE_ID
END

GO


